<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/GestoreUtenti.php";
    include "../gUtil/GeneratoreEmail.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/GestoreStoricoOperazioni.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/Utente.php";
    
    session_start();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb      = new DbManager($costantiDatabase);
    $impostazioni  = recuperaImpostazioni($geecomDb);
    $gestoreUtenti = new GestoreUtenti($geecomDb,$datiGestoreLogin);
    $gestoreStoricoOperazioni = new GestoreStoricoOperazioni($geecomDb,"Admin");
            
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $idUtente   = isset($_GET["idUtente"]) ? filter_input(INPUT_GET,"idUtente",FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $idUtente   = isset($_POST["idUtente"]) ? filter_input(INPUT_POST,"idUtente",FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    
    $utente = new Utente($geecomDb, $idUtente);
    $utente->caricaDatiDalDatabase();
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiGeecomAdmin         = $geecomDb->leggiSingolaRiga("geec_prodotti", 2) ;
    $urlAreaAmministrativa = str_replace("../","",$datiGeecomAdmin["percorso"]);
    switch ($operazione) {
        case 'creaUtente':
            controlloAccessoAdmin();
            $utente->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCognome(filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setSesso(filter_input(INPUT_POST,"sesso",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setEmail(filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setPec(filter_input(INPUT_POST,"pec",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setTelefono(filter_input(INPUT_POST,"telefono",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setNote(filter_input(INPUT_POST,"note",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setOrganizzazione(filter_input(INPUT_POST,"organizzazione",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setVia(filter_input(INPUT_POST,"via",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCitta(filter_input(INPUT_POST,"citta",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCap(filter_input(INPUT_POST,"cap",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setDataNascita(filter_input(INPUT_POST,"dataNascita",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setLuogoNascita(filter_input(INPUT_POST,"luogoNascita",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setProvinciaNascita(filter_input(INPUT_POST,"provinciaNascita",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setRuolo(filter_input(INPUT_POST,"ruolo",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setSitoWeb(filter_input(INPUT_POST,"sitoWeb",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCodiceFiscale(filter_input(INPUT_POST,"codiceFiscale",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setPartitaIva(filter_input(INPUT_POST,"partitaIva",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCodiceInterscambio(filter_input(INPUT_POST,"codiceInterscambio",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setStato(filter_input(INPUT_POST,"stato",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setRicezioneMail(filter_input(INPUT_POST,"ricezioneMail",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setEtichetta(filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_ADD_SLASHES));
            $idUtente = $utente->crea();
            
            $password = $_POST["password"];
            if($password!="") {
                $passwordCriptata    = hash("sha512",$_POST['password']);
                $queryCambioPassword = "UPDATE geec_utenti SET password = '$passwordCriptata' WHERE id={$idUtente}";
                $geecomDb->eseguiQueryScrittura($queryCambioPassword);
            }
            
            $testoOperazione = "{$_SESSION["geecomAdmin_nomeCognome"]} ha creato l'utente {$utente->getNome()} {$utente->getCognome()} {$utente->getEmail()} con ruolo {$utente->getRuolo()} . Id assegnato: $idUtente";
            $gestoreStoricoOperazioni->aggiungiElemento("aggiutaUtente", filter_var($testoOperazione,FILTER_SANITIZE_ADD_SLASHES));
            
            header("Location: ../$urlAreaAmministrativa/creaUtente.php?id=$idUtente&status=200");
            break;
        case 'modificaUtente':
            controlloAccessoAdmin();
            $utente->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCognome(filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setSesso(filter_input(INPUT_POST,"sesso",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setEmail(filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setPec(filter_input(INPUT_POST,"pec",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setTelefono(filter_input(INPUT_POST,"telefono",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setNote(filter_input(INPUT_POST,"note",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setOrganizzazione(filter_input(INPUT_POST,"organizzazione",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setVia(filter_input(INPUT_POST,"via",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCitta(filter_input(INPUT_POST,"citta",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCap(filter_input(INPUT_POST,"cap",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setDataNascita(filter_input(INPUT_POST,"dataNascita",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setLuogoNascita(filter_input(INPUT_POST,"luogoNascita",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setProvinciaNascita(filter_input(INPUT_POST,"provinciaNascita",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setRuolo(filter_input(INPUT_POST,"ruolo",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setSitoWeb(filter_input(INPUT_POST,"sitoWeb",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCodiceFiscale(filter_input(INPUT_POST,"codiceFiscale",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setPartitaIva(filter_input(INPUT_POST,"partitaIva",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCodiceInterscambio(filter_input(INPUT_POST,"codiceInterscambio",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setStato(filter_input(INPUT_POST,"stato",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setRicezioneMail(filter_input(INPUT_POST,"ricezioneMail",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setEtichetta(filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_ADD_SLASHES));
            $utente->modifica();
            
            $password = $_POST["password"];
            if($password!="") {
                $passwordCriptata    = hash("sha512",$_POST['password']);
                $queryCambioPassword = "UPDATE geec_utenti SET password = '$passwordCriptata' WHERE id={$idUtente}";
                $geecomDb->eseguiQueryScrittura($queryCambioPassword);
            }
            
            header("Location: ../$urlAreaAmministrativa/creaUtente.php?id=$idUtente&status=220");
            break;
        case 'creaEStampaId':
            controlloAccessoAdmin();
            $utente->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCognome(filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setStato(filter_input(INPUT_POST,"stato",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setRuolo(filter_input(INPUT_POST,"ruolo",FILTER_SANITIZE_ADD_SLASHES));
            echo $utente->crea();
            break;
        case 'creaUtenteEInviaMail': 
            /* 
             * invocato dalla funzione registrazionePaginaCarrello() del componente ecommerce, marketplace e dalle funzioni 
             * generate delle form che hanno come azione "Inserisci utente in Geecom Admin"
             */
        
            $passwordInviata = filter_input(INPUT_POST,"password",FILTER_SANITIZE_ADD_SLASHES);
            if($passwordInviata=="") {
                $passwordInChiaro = generaPassword(7);
            }
            else {
                $passwordInChiaro = $passwordInviata;
            }
            
            $ruolo = isset($_POST["ruolo"]) ? filter_input(INPUT_POST,"ruolo",FILTER_SANITIZE_ADD_SLASHES) : "utente";
            $stato = isset($_POST["stato"]) ? filter_input(INPUT_POST,"stato",FILTER_SANITIZE_ADD_SLASHES) : "attivo";
            
            $nome  = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $email = filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES);
            $utente->setNome($nome);
            $utente->setCognome(filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setEmail($email);
            $utente->setPassword(hash("sha512",$passwordInChiaro));
            $utente->setPec(filter_input(INPUT_POST,"pec",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setTelefono(filter_input(INPUT_POST,"telefono",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setNote(filter_input(INPUT_POST,"note",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setOrganizzazione(filter_input(INPUT_POST,"organizzazione",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setVia(filter_input(INPUT_POST,"via",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCitta(filter_input(INPUT_POST,"citta",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCap(filter_input(INPUT_POST,"cap",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setRuolo($ruolo);
            $utente->setSitoWeb(filter_input(INPUT_POST,"sitoWeb",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCodiceFiscale(filter_input(INPUT_POST,"codiceFiscale",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setPartitaIva(filter_input(INPUT_POST,"partitaIva",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setCodiceInterscambio(filter_input(INPUT_POST,"codiceInterscambio",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $utente->setStato($stato);
            $idUtente = $utente->crea();
            
            // codice per l'invio della mail
            $datiModuloRegistrazione = $geecomDb->leggiSingolaRiga("geecAd_moduliRegistrazione", 1);
            $datiEmail               = $geecomDb->leggiSingolaRiga("geec_templateEmail", 1);
            $generatoreEmail         = new GeneratoreEmail($impostazioni["emailMittente"], $impostazioni["nomeMittente"]);
            
            $oggetto          = "Creazione account";
            $link 	       = $impostazioni['urlPiattaforma'];
            $messaggio        = "Ciao $nome, <br><br> {$datiModuloRegistrazione["contenutoEmailRegistrazione"]}";
	     
            if($datiModuloRegistrazione["inviaPasswordViaEmail"]=="si") {
                $messaggio .= "<br> La tua password è <b>$passwordInChiaro</b>, ricordati di cambiarla al primo accesso.";
            }

            $corpoMail = str_replace("___corpoTesto___",$messaggio,$datiEmail['corpoMail']);
            $html = "<!doctype html>
                <html>
                    <head>
                        <meta name=\"viewport\" content=\"width=device-width\" />
                        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                        <title>$oggetto</title>
                        <style>
                            {$datiEmail['css']}
                        </style>
                    </head>
                    <body class=\"\">
                </body>
                $corpoMail
                {$datiEmail['footerMail']}";
            
            $htmlMail = str_replace("testo_da_inserire",$messaggio,$html);
            $generatoreEmail->invia($email, $oggetto, $htmlMail);

            echo $idUtente;
            break;
        case 'modificaPasswordAmministrazione':
            controlloAccessoAdmin();
            $utente->setId($_SESSION["geecomAdmin_id"]);
            $utente->cambiaPassword(filter_input(INPUT_POST,"nuovaPassword"));
            echo"ok";
            break;
        case 'duplicaUtente':
            controlloAccessoAdmin();
            $utente->caricaDatiDalDatabase();
            $idUtenteDuplicato = $utente->duplica();
            header("Location: ../$urlAreaAmministrativa/creaUtente.php?id=$idUtenteDuplicato&status=230");
            break;
        case 'aggiungiAGruppo':
            controlloAccessoAdmin();
            $idGruppo = filter_input(INPUT_POST,"idGruppo",FILTER_SANITIZE_NUMBER_INT);
            echo $utente->aggiungiAGruppo($idGruppo);
            break;
        case 'eliminaDalGruppo':
            controlloAccessoAdmin();
            $idGruppo = filter_input(INPUT_POST,"idGruppo",FILTER_SANITIZE_NUMBER_INT);
            $query = "DELETE FROM geec_gruppiUtenti WHERE idUtente = {$utente->getId()} AND idGruppo=$idGruppo";
            $geecomDb->eseguiQueryLettura($query);
            echo"ok";
            break;
        case 'stampaGruppiAssociatiUtente':
            controlloAccessoAdmin();
            $query = "SELECT * FROM geec_gruppiUtenti WHERE idUtente = {$utente->getId()}";
            $risGruppiUtente = $geecomDb->eseguiQueryLettura($query);
            if($risGruppiUtente->num_rows==0) {
                echo"<h4 id=\"stringaNessunGruppo\">Questo utente non è associato a gruppi </h4>";
            }
            else {
                while($gruppo = $risGruppiUtente->fetch_assoc()) {    
                    $datiGruppo = $geecomDb->leggiSIngolaRiga("geec_gruppi",$gruppo["idGruppo"]);
                    echo"<div id=\"divGruppo{$datiGruppo["id"]}\" class=\"d-inline-block mr-2 mb-2\">
                            <button type=\"button\" class=\"btn btn-primary round\" onclick=\"eliminaDalGruppo({$datiGruppo["id"]})\">{$datiGruppo["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                        </div>";
                }
            }
            break;
        case 'modificaImmagine':
            controlloAccessoAdmin();
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/contenuti", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }

                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }

                if($impostazioni["generaThumbnail"]=="si") {
                    $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                    $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
                }
            }
    
            $utente->aggiornaFoto($percorsoFoto);
            echo "../$percorsoFoto";
            break;
        case 'eliminaImmagineInEvidenza':
            controlloAccessoAdmin();
            $utente->aggiornaFoto("");
            echo "ok";
            break;
        case 'aggiornaStatoUtente':
            controlloAccessoAdmin();
            $stato = filter_input(INPUT_POST,"stato",FILTER_SANITIZE_ADD_SLASHES);
            if($_SESSION["geecomAdmin_ruolo"]=="super admin") {
                $utente->aggiornaStato($stato);
                echo "ok";
            }
            else {
                echo "Errore: solo i super admin possono cambiare lo stato degli utenti";
            }
            break;
        case 'eliminaUtente':
            controlloAccessoAdmin();
            if($_SESSION["geecomAdmin_ruolo"]=="super admin") {
                $utente->elimina();
                $testoOperazione = "{$_SESSION["geecomAdmin_nomeCognome"]} ha eliminato l'utente con id {$utente->getId()}";
                $gestoreStoricoOperazioni->aggiungiElemento("eliminazioneUtente", filter_var($testoOperazione,FILTER_SANITIZE_ADD_SLASHES));
                echo "ok";
            }
            else {
                echo "Errore: solo i super admin possono eliminare gli utenti";
            }
            break;
        case 'login':
            $email    = filter_input(INPUT_POST,"email",FILTER_SANITIZE_EMAIL);
            $password = filter_input(INPUT_POST,"password"); // il campo password non è filtrato dato che verrà fatto un hash
            $utente = $gestoreUtenti->login($email, $password);
            if($utente!=null) {
                session_start();
                $_SESSION["geecomUser_id"]   = $utente["id"];
                $_SESSION["geecomUser_email"] = $utente["email"];
                $_SESSION["geecomUser_nomeCognome"] = $utente["nome"]." ".$utente["cognome"];
                $_SESSION["geecomUser_nome"]        = $utente["nome"];
                $_SESSION["geecomUser_tipoLogin"]   = "email";
                header("Location: ../index.php");
            }
            else {
                header("Location: ../index.php?alias=login");
            }
            break;
        case 'loginAmministratore':
            $gestoreUtenti->login($email, $password);
            break;
        case 'logout':
            $gestoreUtenti->logout();
            session_start();
            session_destroy();
            header("Location: ../index.php");
            break;
        case 'logoutAmministratore':
            $gestoreUtenti->logout();
            break;
        case 'registrazioneUtente':
            $nome    = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $cognome = filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_ADD_SLASHES);
            $email   = filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES);
            $password = filter_input(INPUT_POST,"password"); // il campo password non è filtrato dato che verrà fatto un hash
            $idUtente = $gestoreUtenti->registrazioneUtente("utente", "attivo", $nome, $cognome, $email, $password);
            header("Location: ../index.php?alias=grazie-per-esserti-registrato");
            break;
    }
        
    function generaPassword($lunghezza) {
        $lunghezzaStringa = $lunghezza -2;
        
        $nuovaPassword = "";
        $nuovaPassword = $nuovaPassword . chr(rand(65,90)); //stampa una lettera maiuscola a caso
        for ($i=0; $i<$lunghezzaStringa; $i++) {
            $nuovaPassword = $nuovaPassword . chr(rand(97,122)); //stampa una lettera minuscola a caso
        }	
        $nuovaPassword = $nuovaPassword . rand(10,99); //infine aggiunge dei numeri
        return $nuovaPassword;
    }
